/** @ingroup N3
 * \file apfw_get_debug.h
 * \brief APFW_GET_DEBUG primitive
 */

#ifndef APFW_GET_DEBUG_H_
#define APFW_GET_DEBUG_H_

#include "../base_types.h"
#include "definitions.h"


#ifdef __cplusplus
extern "C" {
#endif

/** @ingroup N3
   \brief APFW_GET_DEBUG.REQ

   This primitive is used to query the STA to provide a set of stored
   information corresponding to Asserts or Flashed values such as
   number of boots, etc.
*/
typedef struct
{
   TU8 command; /*!< Requested operation:
                  0x00 Asserts list
                  0x01 Flased Watchdog Values: Num of boots, resets, asserts */
   TU8 extended_info_length; //!< length in bytes of extended command info
   TU8 extended_info[255]; //!< Extended command information.
} tS_APFW_GET_DEBUG_REQ;


/** @ingroup N3
   \brief APFW_GET_DEBUG.CNF
*/
typedef struct
{
   TU16  len;  //!< Length of data in bytes
   TU8   *Data;   //!< Queried information.
} tS_APFW_GET_DEBUG_CNF;


/** @ingroup N3
   \brief This is the struct to hold the transaction response.
*/
typedef struct
{
    tE_TransactionResult  result;   //!< Transaction result
    tS_APL2C_ERROR_CNF    err;      //!< APL2C_ERROR_CNF
    tS_APFW_GET_DEBUG_CNF  cnf; //!< APFW_GET_DEBUG.CNF
} tS_APFW_GET_DEBUG_Result;


/** @ingroup N3
   \brief Execute APFW_GET_DEBUG

   \param req request primitive.
   \param result  Transaction result.
*/
void Exec_APFW_GET_DEBUG(
   const tS_APFW_GET_DEBUG_REQ req,
   tS_APFW_GET_DEBUG_Result *result);

/** @ingroup N3
   \brief   Deallocate resources from a APFW_GET_DEBUG.CNF

   \param cnf  APFW_GET_DEBUG.CNF
*/
void Free_APFW_GET_DEBUG_CNF(tS_APFW_GET_DEBUG_CNF *cnf);

#ifdef __cplusplus
}
#endif

#endif /*APFW_GET_DEBUG_H_*/
